(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     24295,        541]*)
(*NotebookOutlinePosition[     24996,        565]*)
(*  CellTagsIndexPosition[     24952,        561]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData[{
  "Pr\[AAcute]ctica 1. ",
  StyleBox["Asignaci\[OAcute]n y asignaci\[OAcute]n diferida. Listas y reglas \
de sustituci\[OAcute]n. ",
    FontSize->24],
  " \n",
  StyleBox["Localizaci\[OAcute]n de variables. Gr\[AAcute]ficas y primitivas \
gr\[AAcute]ficas.",
    FontSize->24]
}], "Title"],

Cell[CellGroupData[{

Cell["Normas para entregar los trabajos de pr\[AAcute]cticas", "Section"],

Cell["\<\
Como esta es la primera pr\[AAcute]ctica de este curso lo primero que debes \
hacer es leer con atenci\[OAcute]n las siguientes normas para entregar los \
trabajos de pr\[AAcute]cticas.\
\>", "Text"],

Cell[TextData[{
  "1",
  StyleBox[" Borrar salidas",
    FontWeight->"Bold"],
  ". Cuando termines de hacer una pr\[AAcute]ctica con Mathematica es muy \
importante que borres todas las salidas antes de cerrar el cuaderno. Para \
ello vas a kernel \[Rule] Delete all Output. De esta forma un archivo con una \
pr\[AAcute]ctica no debe ocupar m\[AAcute]s de 40k. Ten en cuenta que los \
archivos de Mathematica que contienen gr\[AAcute]ficos se corrompen con \
cierta frecuencia. Esto lo evitas suprimiendo las salidas antes de cerrar el \
cuaderno. Con ello no pierdes nada porque tu trabajo son los comandos y \
funciones que t\[UAcute] has definido y esos no se borran y pueden ejecutarse \
cuando el cuaderno se abra de nuevo.\n2 ",
  StyleBox["Formato",
    FontWeight->"Bold"],
  ". Debe usarse la hoja de estilo Classroom (Format\[Rule]Style \
Sheet\[Rule]Classroom) y magnificaci\[OAcute]n 150 \
(Format\[Rule]Magnification\[Rule]150). Basta con hacer esto antes de cerrar \
la pr\[AAcute]ctica por \[UAcute]ltima vez para entregarla.\n3 ",
  StyleBox["Enunciados y soluciones",
    FontWeight->"Bold"],
  ". El archivo de la pr\[AAcute]ctica debe tener solamente los enunciados de \
los ejercicios y las soluciones. Para copiar los enunciados de los ejercicios \
se selecciona la celda (no selecciones el texto directamente) que contiene el \
enunciado y se copia y pega. \n4 ",
  StyleBox["Ejecuci\[OAcute]n de comandos",
    FontWeight->"Bold"],
  ". Cada celda debe contener toda la informaci\[OAcute]n necesaria para \
poder ser ejecutada inmediatamente evitando que tengan que ejecutarse varias \
celdas para conseguir el resultado deseado. Esto no quiere decir que cada \
celda contenga las definiciones de todos los comandos precisos para su \
ejecuci\[OAcute]n. Basta con que dichos comandos est\[EAcute]n activos cuando \
dicha celda sea ejecutada. Puede que esto obligue a repetir definiciones \
dadas en celdas anteriores si es que estas se han borrado con un Clear[ ].\n5 \
",
  StyleBox["Comprobaci\[OAcute]n de comandos",
    FontWeight->"Bold"],
  ". Tienes que comprobar que los comandos que has definido funcionan \
correctamente. Antes de entregar la pr\[AAcute]ctica debes comprobar todos y \
cada uno de los comandos. Si alguno no funciona correctamente y no sabes \
corregirlo debes indicar claramente que el comando que has escrito no \
funciona correctamente. Si al ejecutar un comando se llena la pantalla de \
mensajes de error o se cuelga el ordenador, el ejercicio correspondiente ser\
\[AAcute] calificado con 0. \n6 ",
  StyleBox["Mensajes de error",
    FontWeight->"Bold"],
  ". Debes evitar los mensajes de error debido a que los nombres que usas son \
muy parecidos entre s\[IAcute] o a otros propios de Mathematica. Usa nombres \
apropiados para tus comandos que no interfieran entre si ni con los del \
programa.\n7 ",
  StyleBox["Limpiar variables y otros consejos",
    FontWeight->"Bold"],
  ". Debes usar Clear[\"lo que sea\"] o Clear[\"Global`*\"] siempre que sea \
necesario pero sin excederse; si, por ejemplo, vas a usar un mismo comando en \
varios apartados de un mismo ejercicio es una p\[EAcute]rdida de tiempo que \
borres el comando al final de cada apartado. Es preferible usar \
Clear[\"Global`*\"] al final de un comando que al principio. No olvides, \
despu\[EAcute]s de usar Clear[\"Global`*\"], repetir las definiciones \
necesarias para que todo funcione. No debes empezar una celda \"input\" con \
un comentario ni tampoco con un Clear[ ] porque eso produce a veces errores \
(la celda no se ejecuta). Tampoco es conveniente incluir demasiado \
c\[OAcute]digo en una misma celda. Si un  ejercicio tiene varios apartados no \
debes agruparlos todos en una misma celda sino hacer cada uno de ellos por \
separado. Muchos errores se deben a efectos derivados de \"copiar y pegar\". \
Para copiar en ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " NO se selecciona texto sino que se selecciona la celda entera (como se \
seleccionan celdas) se copia y se pega y, si es necesario, despu\[EAcute]s se \
borra lo que sobre.\n8 ",
  StyleBox["Formaci\[OAcute]n de equipos",
    FontWeight->"Bold"],
  ". Para realizar las pr\[AAcute]cticas deben formarse equipos de tres \
componentes.\n9 ",
  StyleBox["Identificaci\[OAcute]n de las pr\[AAcute]cticas",
    FontWeight->"Bold"],
  ". Cada pr\[AAcute]ctica debe entregarse en un disquete. El disquete \
contendr\[AAcute] solamente el archivo de la pr\[AAcute]ctica. Cada equipo \
debe entregar solamente una pr\[AAcute]ctica. Para identificar la \
pr\[AAcute]ctica debe ponerse como nombre del archivo los apellidos del \
componente del equipo cuyos apellidos sean los primeros en orden alfab\
\[EAcute]tico, en min\[UAcute]sculas y seguido del n\[UAcute]mero de la pr\
\[AAcute]ctica. Es decir, si un equipo est\[AAcute] formado por Ruiz D\
\[IAcute]az, Dom\[IAcute]nguez Ortiz y P\[EAcute]rez Cano el archivo debe \
identificarse como dominguezortiz_q (con extensi\[OAcute]n .nb naturalmente) \
donde q es el n\[UAcute]mero de la pr\[AAcute]ctica. El disquete que contiene \
la pr\[AAcute]ctica debe identificarse con los nombres de todos los \
componentes del equipo en orden alfab\[EAcute]tico, el curso al que \
pertenecen y la titulaci\[OAcute]n, y tambi\[EAcute]n debe figurar dicha \
informaci\[OAcute]n al principio de la pr\[AAcute]ctica. No se calificar\
\[AAcute]n las pr\[AAcute]cticas que no est\[EAcute]n correctamente \
identificadas.\n10 ",
  StyleBox["Fecha de entrega",
    FontWeight->"Bold"],
  ". La fecha l\[IAcute]mite de entrega de cada pr\[AAcute]ctica se dir\
\[AAcute] en clase y se pondr\[AAcute] en la p\[AAcute]gina Web de la \
asignatura con suficiente antelaci\[OAcute]n."
}], "Text"],

Cell[CellGroupData[{

Cell["Calificaci\[OAcute]n de las pr\[AAcute]cticas", "Subsection"],

Cell["\<\
Cada ejercicio se califica de 0 a 10 y al final de la pr\[AAcute]ctica se da \
una calificaci\[OAcute]n global, tambi\[EAcute]n de 0 a 10, que no tiene por \
qu\[EAcute] ser necesariamente la media de las calificaciones de todos los \
ejercicios. En la calificaci\[OAcute]n se tiene en cuenta no solamente la \
correcci\[OAcute]n de las soluciones dadas sino tambi\[EAcute]n la claridad \
de las explicaciones, la adecuaci\[OAcute]n de la soluci\[OAcute]n propuesta \
a lo que se pide en el enunciado, la \"eficacia\" de los comandos definidos \
(por ejemplo, los comandos que definas para hacer c\[AAcute]lculos num\
\[EAcute]ricos deben trabajar num\[EAcute]ricamente), el control de la \
precisi\[OAcute]n de los resultados obtenidos (cuando ello tenga sentido) y, \
en general, todo lo que hace que la soluci\[OAcute]n propuesta sea \
m\[AAcute]s o menos eficiente, sencilla y elegante. Las pr\[AAcute]cticas \
realizadas en equipo se eval\[UAcute]an con los mismos criterios que las \
realizadas individualmente y su calificaci\[OAcute]n es, naturalmente, para \
todos los miembros del equipo.\
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Observaciones (quiz\[AAcute]s innecesarias)", "Subsection"],

Cell[TextData[{
  "El trabajo de pr\[AAcute]cticas debe ser un trabajo personal. Debes ser \
capaz de explicar con detalle el trabajo que has hecho en cualquiera de las \
pr\[AAcute]cticas que hayas entregado. No debes concederte la debilidad de \
copiar el trabajo realizado por otro compa\[NTilde]ero. Los intentos de \
disfrazar el c\[OAcute]digo cambiando nombres de variables, modificando los \
comentarios o alterando el orden son muy f\[AAcute]ciles de descubrir. En el \
caso de que las pr\[AAcute]cticas de dos alumnos se \"parezcan demasiado\" \
ambas ser\[AAcute]n calificadas ",
  StyleBox["como se merecen",
    FontSlant->"Italic"],
  "."
}], "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicios", "ExerciseMain"],

Cell[TextData[{
  "En los siguientes ejercicios debes usar, siempre que sea posible, los \
comandos de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " estudiados en esta pr\[AAcute]ctica. Procura evitar el uso de comandos \
propios de programaci\[OAcute]n procedimental (For, bucles,...)."
}], "ExerciseText"],

Cell[CellGroupData[{

Cell["Ejercicio 1", "Exercise"],

Cell[TextData[{
  "Haz un programa que calcule y clasifique los puntos cr\[IAcute]ticos de \
una funci\[OAcute]n de dos variables, ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y)\)]],
  ", que se supone conocida. El programa debe proporcionar como salida la \
lista de los puntos cr\[IAcute]ticos reales, la lista de los puntos de silla, \
la lista de los m\[AAcute]ximos relativos, la lista de los m\[IAcute]nimos \
relativos y la lista de los puntos que son casos dudosos. Comprueba tu \
programa con la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y) = \(x\^5\) y\^3 - 2 \( x\^3\) y\^3 + 
          6 \( x\^2\) y + 6 \( y\^2\) x - 4  x\ y + 7  y - 5  x + 8\)]],
  ".\n",
  StyleBox["Sugerencias",
    FontWeight->"Bold"],
  ". Debes definir un comando de la forma \"clasificaextremos[func_]\" cuya \
\[UAcute]nica variable es la funci\[OAcute]n de dos variables, \"func\", que \
le vamos a pasar. Debes empezar por calcular los puntos cr\[IAcute]ticos de \
\"func\" que, como debes saber, son los puntos en los que se anulan las \
derivadas parciales de primer orden de \"func\". Para calcularlos debes usar \
NSolve[ ] porque no podemos confiar en que puedan obtenerse soluciones \
exactas. Seguidamente, debes seleccionar los puntos cr\[IAcute]ticos reales \
(los imaginarios no interesan). El resultado obtenido debes imprimirlo en \
pantalla. Seguidamente, debes calcular la matriz hessiana de \"func\", \
evaluarla en cada uno de los puntos cr\[IAcute]ticos y calcular los valores \
propios de cada una de las matrices obtenidas (usa el comando Eigenvalues[ \
]). Puede ser \[UAcute]til que crees una lista cuyos elementos sean de la \
forma {{x,y},{a,b}} donde {x,y} es un punto cr\[IAcute]tico y {a,b} son los \
valores propios de la matriz hesiana de \"func\" evaluada en dicho punto cr\
\[IAcute]tico. A continuaci\[OAcute]n debes definir una funci\[OAcute]n \
boleana que clasifique cada punto cr\[IAcute]tico seg\[UAcute]n los valores \
propios de su correspondiente matriz hessiana; la salida de esta funci\
\[OAcute]n debe ser de la forma \"{x,y} es un m\[AAcute]ximo relativo\" \
(cuando los dos valores propios son negativos), \"{x,y} es un m\[IAcute]nimo \
relativo\" (cuando los dos valores propios son positivos), \"{x,y} es un \
punto de silla\" (cuando los dos valores propios tienen distinto signo), \"no \
sabemos si hay extremo en {x,y}\" (cuando alguno de los valores propios es \
cero). Si esta funci\[OAcute]n la defines de forma apropiada para que pueda \
aplicarse a la lista anterior habr\[AAcute]s acabado el trabajo.\nEs \
conveniente que uses una estructura Module[ ] y localices las funciones y \
variables de salida; por ejemplo, usa como variables locales \"puntoscriticos\
\", \"valoreshesiano\", \"valorespropios\", \"clasifica\",... "
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 2", "Exercise"],

Cell[TextData[{
  "Define, usando comandos apropiados para generar y trabajar con listas, un \
comando que calcule sumas de Riemann de una funci\[OAcute]n de una variable y \
de una funci\[OAcute]n de dos variables. La funci\[OAcute]n debe evaluarse en \
el punto medio de cada intervalo de la partici\[OAcute]n.\n",
  StyleBox["Sugerencias",
    FontWeight->"Bold"],
  ". Debes definir un comando de la forma \"sumarieman[func_,a_,b_,n_]\" \
donde las variables son la funci\[OAcute]n de una variable, \"func\", los \
extremos del intervalo, [a,b], y el n\[UAcute]mero de partes iguales, n, en \
que se divide dicho intervalo. La salida del comando debe ser la suma de los \
valores de \"func\" en los puntos medios de todos los subintervalos \
multiplicada por la longitud de dichos subintervalos. Este n\[UAcute]mero, \
para n suficientemente grande, es una buena aproximaci\[OAcute]n de la \
integral ",
  Cell[BoxData[
      \(TraditionalForm\`\[Integral]\_a\%b\( f(x)\) \[DifferentialD]x\)]],
  ".\nPara el caso de una funci\[OAcute]n de dos variables se procede de \
forma parecida. Ahora debes considerar dos intervalos; uno [a,b] que se \
dividir\[AAcute] en n partes iguales y otro [c,d] que se dividir\[AAcute] en \
m partes iguales. De esta forma dividimos el rect\[AAcute]ngulo [a,b]",
  StyleBox["\[Times]",
    FontWeight->"Bold"],
  "[c,d] en n",
  StyleBox["\[Times]",
    FontWeight->"Bold"],
  "m rectangulitos. Debes evaluar la funci\[OAcute]n en el punto medio de \
todos ellos, sumar estos valores y multiplicar por el \[AAcute]rea de dichos \
rectangulitos. Tu comando debe ser ahora de la forma \
\"sumarieman2D[func_,a_,b_,c_,d_,n_,m_]\" y proporcionar\[AAcute] una buena \
aproximaci\[OAcute]n de la integral doble ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[Integral]", 
          RowBox[{
            SubscriptBox["\[Integral]", 
              RowBox[{\([a, b]\), 
                StyleBox["\[Times]",
                  FontWeight->"Bold"], \([c, d]\)}]], \(\(f(x, 
                y)\) \[DifferentialD]\((x, y)\)\)}]}], TraditionalForm]]],
  ".\nPor supuesto, estos comandos deben trabajar num\[EAcute]ricamente. \n\
Aplica tu comando a las funciones:\na) ",
  Cell[BoxData[
      \(TraditionalForm\`f[x] = Cos[1/x]/x\)]],
  " en el intervalo ",
  Cell[BoxData[
      \(TraditionalForm\`\([1/10, 1]\)\)]],
  " dividido en 40000 partes iguales. Comprueba la duraci\[OAcute]n del c\
\[AAcute]lculo con el comando Timing[ ] (si tu comando est\[AAcute] bien \
definido, este c\[AAcute]lculo debe hacerse en menos de medio segundo). \
Comprueba tu resultado usando el comando de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " NIntegrate[ ] para calcular num\[EAcute]ricamente la integral de ",
  Cell[BoxData[
      \(TraditionalForm\`Cos[1/x]/x\)]],
  " en el intervalo [1/10,1].\nb) g[x,y]=Cos[1/(xy)] en el intervalo ",
  Cell[BoxData[
      \(TraditionalForm\`\([1/10, 1]\)\[Times]\([1/10, 1]\)\)]],
  " dividido en 40000 rectangulitos iguales. Comprueba la duraci\[OAcute]n \
del c\[AAcute]lculo con el comando Timing[ ] (si tu comando est\[AAcute] bien \
definido, este c\[AAcute]lculo debe hacerse en menos de medio segundo). \
Comprueba tu resultado usando el comando de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " NIntegrate[ ] para calcular num\[EAcute]ricamente la integral de ",
  Cell[BoxData[
      \(TraditionalForm\`Cos[1/\((x\ y)\)]\)]],
  " en el intervalo [1/10,1]\[Times][1/101,1]."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 3", "Exercise"],

Cell["a) Explica con detalle lo que hace el siguiente comando.", \
"ExerciseText"],

Cell[BoxData[
    \(iteraciones[f_Symbol, p_Integer, n_Integer, m_Integer] := 
      Prepend[Take[NestList[f, Range[0. , 1. , N[1/p]], n], \(-m\)], 
          Range[0. , 1. , N[1/p]]] /; n > m\)], "Input"],

Cell["b) Transforma la lista siguiente", "ExerciseText"],

Cell[BoxData[{
    \(\(f[x_] = 3.4\ x\ \((1 - x)\);\)\), "\[IndentingNewLine]", 
    \(lista = iteraciones[f, 5, 105, 5]\)}], "Input"],

Cell[TextData[{
  "en una lista de pares {a,b} cuyo primer elemento \"a\" toma los valores de \
la lista inicial Range[0.,1.,.2] , y para cada uno de ellos el segundo \
elemento \"b\" recorre los valores obtenidos al iterar sobre \[EAcute]l la \
funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f \((x)\) = 3.4\ x\ \((1 - x)\)\)]],
  ". Procura eliminar las repeticiones. \nc) Representa gr\[AAcute]ficamente \
la lista obtenida en el apartado anterior con opciones de tama\[NTilde]o y \
color apropiadas para que los puntos se vean bien. Interpreta lo que ves.\nd) \
Define un comando al que le pasaremos como entrada una lista como la del \
apartado b) y cuya salida debe ser una gr\[AAcute]fica como la obtenida en el \
apartado c). Comprueba tu comando con la lista dada en el apartado b).\ne) \
Aplica el comando definido en el apartado anterior a la siguiente lista. \
Interpreta lo que ves."
}], "ExerciseText"],

Cell[BoxData[{
    \(Clear[f, lista]\), "\[IndentingNewLine]", 
    \(\(f[x_] = 3.4\ x\ \((1 - x)\);\)\), "\[IndentingNewLine]", 
    \(\(lista = iteraciones[f, 100, 500, 100];\)\), "\[IndentingNewLine]", 
    \( (*\[DownExclamation]no\ quites\ el\ ; ! \ *) \)}], "Input"],

Cell[BoxData[{
    \(Clear[f, lista]\), "\[IndentingNewLine]", 
    \(\(\(f[x_] = 3.7\ x \((1 - x)\)\)\(;\)\(\ \)\( (*\ 
      un\ peque\[NTilde]o\ cambio\ en\ la\ funci\[OAcute]n\ *) \)\(\
\[IndentingNewLine]\)\(lista = 
      iteraciones[f, 100, 500, 
        100]\)\(;\)\(\ \)\( (*\[DownExclamation]no\ quites\ el\ ; ! \ *) \)\)\
\)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 4", "Exercise"],

Cell[TextData[{
  "El llamado \"juego del caos\" aparece en el libro de Michael Barnsley ",
  StyleBox["Fractals Everywhere",
    FontSlant->"Italic"],
  ", Academic Press, San Diego, 1988. Consiste en lo siguiente. Consideramos \
un tri\[AAcute]ngulo equil\[AAcute]tero en el plano. Por ejemplo."
}], "ExerciseText",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \(\(vertices = N[{{0, 0}, {1, 0}, {1\/2, \@3\/2}}];\)\)], "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["\<\
a) Se elige al azar un punto en el cuadrado unidad. Llama \"puntoinicio\" a \
este punto. Este punto debe permanecer fijo en cada ejecuci\[OAcute]n del \
juego.
b) Se define una funci\[OAcute]n, que llamaremos \
\"puntosiguiente[anterior_]\" que es igual al punto medio de \
\"verticealeatorio\" y \"anterior\". Donde se supone que \"anterior\" es un \
punto del plano y \"verticealeatorio\" es un v\[EAcute]rtice del \
tri\[AAcute]ngulo elegido aleatoriamente cada vez que se ejecute la funci\
\[OAcute]n. 
c) El juego del caos consiste en iterar la funci\[OAcute]n definida en el \
apartado anterior a partir del punto de inicio. Define una funci\[OAcute]n \
que llamar\[AAcute]s \"juegodelcaos[n]\" que repita n veces el proceso \
descrito en los apartados anteriores y proporcione como salida la lista de \
todos los puntos obtenidos.
d) Representa gr\[AAcute]ficamente juegodelcaos[puntoinicio,5000]. Elige \
opciones apropiadas. 
Advertencia: No interesa ver en pantalla la salida de \"juegodelcaos[n]\" \
porque puede ser una lista muy grande. Usa, si es necesario \";\" para evitar \
problemas.\
\>", "ExerciseText",
  ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 5", "Exercise"],

Cell[TextData[StyleBox["Supongamos que tenemos una lista de puntos del plano. \
 Por ejemplo, considera la siguiente lista de puntos:",
  FontFamily->"Times New Roman"]], "ExerciseText"],

Cell[BoxData[
    \(\(puntos = Table[{x, Sin[x]}, {x, \(-3\) Pi, 3  Pi,  .3}];\)\)], "Input"],

Cell[TextData[{
  StyleBox["Se trata de representar dichos puntos en rojo y con \
tama\[NTilde]o apropiado as\[IAcute] como los segmentos verticales que unen \
cada uno de ellos con el eje de abscisas y la poligonal en azul que une cada \
punto con el siguiente en la lista.\n",
    FontFamily->"Times New Roman"],
  StyleBox["Sugerencias.",
    FontFamily->"Times New Roman",
    FontWeight->"Bold"],
  StyleBox[" Para representar los segmentos verticales debes obtener las \
coordernadas de los extremos de los segmentos que unen cada punto con el eje \
de abscisas. Te sugiero que apliques la siguiente funci\[OAcute]n",
    FontFamily->"Times New Roman"]
}], "ExerciseText"],

Cell[BoxData[
    \(extremos[{x_, y_}] := {{x, 0}, {x, y}}\)], "Input"],

Cell[TextData[{
  "a la lista \"puntos\" para obtener una lista que llamaremos \
\"puntosextremos\" (puedes usar el comando Map[ ] ).  Ahora debes aplicar el \
comando Line[ ] a cada elemento de \"puntosextremos\" para obtener una nueva \
lista a la que llamaremos \"segmentos\". El resto es inmediato: basta usar ",
  StyleBox["ListPlot[ ] y Epilog. ",
    FontFamily->"Times New Roman"]
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 6", "Exercise"],

Cell[TextData[{
  StyleBox["a)",
    FontWeight->"Bold"],
  " Explica lo que hace ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " al ejecutar los siguientes comandos en los que, aparentemente, una misma \
regla de sustituci\[OAcute]n parece actuar de forma distinta en cada caso."
}], "ExerciseText"],

Cell[BoxData[
    \({{1, 2}, {3, 4}, {5, 6}} /. {x_, y_} -> {x, 2\ y}\)], "Input"],

Cell[BoxData[
    \({{1, 2}, {3, 4}} /. {x_, y_} -> {x, 2\ y}\)], "Input"],

Cell[TextData[{
  StyleBox["b)",
    FontWeight->"Bold"],
  " Modifica la regla anterior, por ejemplo, condicionando el tipo de \
variable sobre el que puede actuar dicha regla (puedes usar, por ejemplo, \
x_?NumericQ),  de manera que al aplicarla sobre una lista de puntos del plano \
siempre proporcione el resultado de multiplicar por dos la segunda coordenada \
y deje igual la primera. \n",
  StyleBox["c)",
    FontWeight->"Bold"],
  " M\[AAcute]s dif\[IAcute]cil: \[DownQuestion]puedes conseguir que dicha \
regla de sustituci\[OAcute]n trabaje simb\[OAcute]licamente, es decir, no \
necesariamente sobre valores num\[EAcute]ricos? O sea que al aplicarla sobre \
{{a,b},{c,d}} lo convierta en {{a,2b},{c,2d}}.\nSugerencia: Busca en la ayuda \
de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " VectorQ. Observa tambi\[EAcute]n que hay diferencia entre aplicar la \
regla de asignaci\[OAcute]n de forma inmediata o diferida. Aunque las dos \
funcionan correctamente, en el primer caso ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " da un mensaje de error \[DownQuestion]sabr\[IAcute]as explicar por qu\
\[EAcute]?."
}], "ExerciseText"],

Cell[TextData[{
  StyleBox["d)",
    FontWeight->"Bold"],
  " Escribe una regla que cuando sea aplicada a una lista de puntos del \
espacio {x,y,z} devuelva pares {x,y}. Comprueba dicha regla \
haci\[EAcute]ndola actuar sobre ",
  "{{x,y,z},{a,b,c},{u,v,w}}."
}], "ExerciseText"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
WindowSize->{1016, 651},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification->1.25,
StyleDefinitions -> "Classroom.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 306, 9, 131, "Title"],

Cell[CellGroupData[{
Cell[2085, 64, 73, 0, 77, "Section"],
Cell[2161, 66, 209, 4, 33, "Text"],
Cell[2373, 72, 5734, 97, 814, "Text"],

Cell[CellGroupData[{
Cell[8132, 173, 67, 0, 64, "Subsection"],
Cell[8202, 175, 1122, 16, 138, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9361, 196, 65, 0, 64, "Subsection"],
Cell[9429, 198, 664, 12, 96, "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[10142, 216, 34, 0, 75, "ExerciseMain"],
Cell[10179, 218, 320, 7, 54, "ExerciseText"],

Cell[CellGroupData[{
Cell[10524, 229, 31, 0, 56, "Exercise"],
Cell[10558, 231, 2819, 43, 407, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[13414, 279, 31, 0, 56, "Exercise"],
Cell[13448, 281, 3482, 69, 444, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[16967, 355, 31, 0, 56, "Exercise"],
Cell[17001, 357, 82, 1, 33, "ExerciseText"],
Cell[17086, 360, 205, 3, 81, "Input"],
Cell[17294, 365, 56, 0, 33, "ExerciseText"],
Cell[17353, 367, 134, 2, 81, "Input"],
Cell[17490, 371, 929, 15, 183, "ExerciseText"],
Cell[18422, 388, 272, 4, 123, "Input"],
Cell[18697, 394, 347, 7, 123, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[19081, 406, 31, 0, 56, "Exercise"],
Cell[19115, 408, 350, 7, 54, "ExerciseText"],
Cell[19468, 417, 117, 2, 80, "Input"],
Cell[19588, 421, 1167, 21, 212, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[20792, 447, 31, 0, 56, "Exercise"],
Cell[20826, 449, 186, 2, 33, "ExerciseText"],
Cell[21015, 453, 93, 1, 60, "Input"],
Cell[21111, 456, 678, 13, 105, "ExerciseText"],
Cell[21792, 471, 71, 1, 60, "Input"],
Cell[21866, 474, 408, 7, 75, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[22311, 486, 31, 0, 56, "Exercise"],
Cell[22345, 488, 311, 8, 55, "ExerciseText"],
Cell[22659, 498, 82, 1, 60, "Input"],
Cell[22744, 501, 74, 1, 60, "Input"],
Cell[22821, 504, 1164, 24, 177, "ExerciseText"],
Cell[23988, 530, 279, 7, 55, "ExerciseText"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

